# coding: utf8

from __future__ import unicode_literals, absolute_import, division, print_function
from sandbox import sdk2


# ====================== release machine builds ======================


class _EducationBinaryRelease(sdk2.Resource):
    releasable = True
    auto_backup = True
    executable = True
    ttl = 'inf'


class _EducationDockerRelease(sdk2.Resource):
    releasable = True
    auto_backup = True
    executable = True
    ttl = 1


# ====================== analytics builds ======================


class EDUCATION_WORKFLOW_BINARY(sdk2.Resource):
    releasable = True
    auto_backup = True
    executable = True
    ttl = 1


# ====================== static resources ======================


class _EducationStaticResource(sdk2.Resource):
    ttl = 'inf'


# ====================== push client conf ======================


class _EducationAwacsPushClientConf(_EducationStaticResource):
    auto_backup = True
    releasable = True
    ttl = 'inf'


# === awacs balancers: education.* ===


class COMMON_EDUCATION_AWACS_PUSH_CLIENT_CONF(_EducationAwacsPushClientConf):
    pass


class COMMON_EDUCATION_TEST_AWACS_PUSH_CLIENT_CONF(_EducationAwacsPushClientConf):
    pass


class STANDS_EDUCATION_TEST_AWACS_PUSH_CLIENT_CONF(_EducationAwacsPushClientConf):
    pass


class COMMON_EDUCATION_DEV_TOOLS_AWACS_PUSH_CLIENT_CONF(_EducationAwacsPushClientConf):
    pass


class UNIVERSAL_EDUCATION_AWACS_PUSH_CLIENT_CONF(_EducationAwacsPushClientConf):
    pass


class UNIVERSAL_EDUCATION_TEST_AWACS_PUSH_CLIENT_CONF(_EducationAwacsPushClientConf):
    pass


# === awacs balancers: anytask|lyceum ===


class COMMON_ANYTASK_BACKEND_PROD_AWACS_PUSH_CLIENT_CONF(_EducationAwacsPushClientConf):
    pass


class COMMON_ANYTASK_FRONTEND_PROD_AWACS_PUSH_CLIENT_CONF(_EducationAwacsPushClientConf):
    pass


class COMMON_LYCEUM_OUTSOURCE_AWACS_PUSH_CLIENT_CONF(_EducationAwacsPushClientConf):
    pass


class CROWD_LYCEUM_OUTSOURCE_AWACS_PUSH_CLIENT_CONF(_EducationAwacsPushClientConf):
    pass


# === awacs balancers: pelican.* ===


class COMMON_PELICAN_WEB_PROD_AWACS_PUSH_CLIENT_CONF(_EducationAwacsPushClientConf):
    pass


class COMMON_PELICAN_API_PROD_AWACS_PUSH_CLIENT_CONF(_EducationAwacsPushClientConf):
    pass


class COMMON_PELICAN_TAKEOUT_PROD_AWACS_PUSH_CLIENT_CONF(_EducationAwacsPushClientConf):
    pass


class COMMON_PELICAN_TEST_AWACS_PUSH_CLIENT_CONF(_EducationAwacsPushClientConf):
    pass


class COMMON_PELICAN_OUTSOURCE_AWACS_PUSH_CLIENT_CONF(_EducationAwacsPushClientConf):
    pass


class CROWD_PELICAN_OUTSOURCE_AWACS_PUSH_CLIENT_CONF(_EducationAwacsPushClientConf):
    pass


# === awacs balancers: sections.* ===


class COMMON_SECTION_AWACS_PUSH_CLIENT_CONF(_EducationAwacsPushClientConf):
    pass


class COMMON_SECTION_API_AWACS_PUSH_CLIENT_CONF(_EducationAwacsPushClientConf):
    pass


class COMMON_SECTION_TEST_AWACS_PUSH_CLIENT_CONF(_EducationAwacsPushClientConf):
    pass


class COMMON_SECTION_API_TEST_AWACS_PUSH_CLIENT_CONF(_EducationAwacsPushClientConf):
    pass


class COMMON_SECTION_OUTSOURCE_AWACS_PUSH_CLIENT_CONF(_EducationAwacsPushClientConf):
    pass


# === awacs balancers: praktikum.* ===


class COMMON_PRAKTIKUM_AWACS_PUSH_CLIENT_CONF(_EducationAwacsPushClientConf):
    pass


class COMMON_PRAKTIKUM_PRESTABLE_AWACS_PUSH_CLIENT_CONF(_EducationAwacsPushClientConf):
    pass


class COMMON_PRAKTIKUM_TEST_AWACS_PUSH_CLIENT_CONF(_EducationAwacsPushClientConf):
    pass


class COMMON_BACKEND_PRAKTIKUM_AWACS_PUSH_CLIENT_CONF(_EducationAwacsPushClientConf):
    pass


class COMMON_BACKEND_PRAKTIKUM_PRESTABLE_AWACS_PUSH_CLIENT_CONF(_EducationAwacsPushClientConf):
    pass


class COMMON_BACKEND_PRAKTIKUM_TEST_AWACS_PUSH_CLIENT_CONF(_EducationAwacsPushClientConf):
    pass


# === awacs balancers: flow.* ===


class COMMON_ENGLISH_AWACS_PUSH_CLIENT_CONF(_EducationAwacsPushClientConf):
    pass


class COMMON_ENGLISH_BACKEND_AWACS_PUSH_CLIENT_CONF(_EducationAwacsPushClientConf):
    pass


class COMMON_ENGLISH_TEST_AWACS_PUSH_CLIENT_CONF(_EducationAwacsPushClientConf):
    pass


# === checking system ===


class EDUCATION_CHECKING_SYSTEM_BINARY(_EducationDockerRelease):
    pass


class EDUCATION_CHECKING_SYSTEM_MIGRATOR_BINARY(_EducationDockerRelease):
    pass


class EDUCATION_CHECKING_SYSTEM_MARKER_CHECKER_BINARY(_EducationDockerRelease):
    pass


# === events collector ===


class EDUCATION_EVENTS_COLLECTOR_BINARY(_EducationDockerRelease):
    pass


# === events sender ===


class EDUCATION_EVENTS_SENDER_BINARY(_EducationBinaryRelease):
    pass


# === crowd test yandex deploy proxy ===


class EDUCATION_CROWD_TEST_YD_PROXY_BINARY(_EducationBinaryRelease):
    pass


# === enigma ===


class EDUCATION_INFRASTRUCTURE_CI_ENIGMA_BINARY(_EducationDockerRelease):
    pass


class EDUCATION_INFRASTRUCTURE_CI_ENIGMA_CRON_BINARY(_EducationDockerRelease):
    pass


# === pdf_gen ===


class EDUCATION_PDF_GEN_BINARY(_EducationDockerRelease):
    pass


# === ext_lms_connector ===


class EDUCATION_EXT_LMS_CONNECTOR_BINARY(_EducationDockerRelease):
    pass


class EDUCATION_EXT_LMS_CONNECTOR_MIGRATOR_BINARY(_EducationDockerRelease):
    pass


class EDUCATION_EXT_LMS_CONNECTOR_RETRY_WORKER_BINARY(_EducationDockerRelease):
    pass


# === sections ===


class EDUCATION_SECTIONS_ADMIN_BINARY(_EducationDockerRelease):
    pass


class EDUCATION_SECTIONS_BINARY(_EducationDockerRelease):
    pass


class EDUCATION_SECTIONS_MIGRATOR_BINARY(_EducationDockerRelease):
    pass


class EDUCATION_SECTIONS_ALEMBIC_MIGRATOR_BINARY(_EducationDockerRelease):
    pass


class EDUCATION_SECTIONS_SCHEDULER_BINARY(_EducationDockerRelease):
    pass


# === media-platform ===


class EDUCATION_MEDIA_PLATFROM_API_BINARY(_EducationDockerRelease):
    pass


class EDUCATION_MEDIA_PLATFROM_API_MIGRATOR_BINARY(_EducationDockerRelease):
    pass


# === recommender ===


class SCHOOLBOOK_RECOMMENDER_BINARY(_EducationDockerRelease):
    pass


class SCHOOLBOOK_RECOMMENDER_MIGRATOR_BINARY(_EducationDockerRelease):
    pass


# === analytics workflows ===


class SCHOOLBOOK_ASYNCHRONOUS_REPORTS_WORKFLOW_BINARY(EDUCATION_WORKFLOW_BINARY):
    pass


class SCHOOLBOOK_DB_WORKFLOW_YQL_PART_BINARY(EDUCATION_WORKFLOW_BINARY):
    pass


class SCHOOLBOOK_DB_WORKFLOW_YT_TO_CH_PART_BINARY(EDUCATION_WORKFLOW_BINARY):
    pass


class SCHOOLBOOK_EXPERIMENT_EMAIL_CLEANUP_WORKFLOW_BINARY(EDUCATION_WORKFLOW_BINARY):
    pass


class SCHOOLBOOK_EXPERIMENT_EMAIL_WORKFLOW_BINARY(EDUCATION_WORKFLOW_BINARY):
    pass


class SCHOOLBOOK_METRIKA_REPORTS_WORKFLOW_BINARY(EDUCATION_WORKFLOW_BINARY):
    pass


class SCHOOLBOOK_TRACKER_PROBLEMS_WORKFLOW_BINARY(EDUCATION_WORKFLOW_BINARY):
    pass


class SCHOOLBOOK_YA_TEACHER_COURSE_COMPLETION_DATA_WORKFLOW_BINARY(EDUCATION_WORKFLOW_BINARY):
    pass


class SCHOOLBOOK_EPICARDS_WORKFLOW_BINARY(EDUCATION_WORKFLOW_BINARY):
    pass

# === analytics workflows ===


class PRAKTIKUM_EDUCATION_METRICA_TO_YT_BINARY(EDUCATION_WORKFLOW_BINARY):
    pass


class PRAKTIKUM_GSHEET_TO_YT_BINARY(EDUCATION_WORKFLOW_BINARY):
    pass


class PRAKTIKUM_IMPORT_DATA_BINARY(EDUCATION_WORKFLOW_BINARY):
    pass


class PRAKTIKUM_FROM_PGAAS_TO_YT_LIGHT_BINARY(EDUCATION_WORKFLOW_BINARY):
    pass


class PRAKTIKUM_FROM_PGAAS_TO_YT_HEAVY_BINARY(EDUCATION_WORKFLOW_BINARY):
    pass


class PRAKTIKUM_CONTENT_ANALYTICS_BINARY(EDUCATION_WORKFLOW_BINARY):
    pass


class PRAKTIKUM_PRAKTIKUM_FUNNEL_BINARY(EDUCATION_WORKFLOW_BINARY):
    pass


class PRAKTIKUM_CLEAR_PRAKTIKUM_TMP_BINARY(EDUCATION_WORKFLOW_BINARY):
    pass


class PRAKTIKUM_FLOW_PGAAS_TO_YT_BINARY(EDUCATION_WORKFLOW_BINARY):
    pass


class PRAKTIKUM_USEDESK_TO_YT_BINARY(EDUCATION_WORKFLOW_BINARY):
    pass


class PRAKTIKUM_CASH_IN_REPORT_BINARY(EDUCATION_WORKFLOW_BINARY):
    pass


class PRAKTIKUM_CLICKUP_TO_YT_BINARY(EDUCATION_WORKFLOW_BINARY):
    pass


class PRAKTIKUM_CONTENT_PLANNED_LESSONS_BINARY(EDUCATION_WORKFLOW_BINARY):
    pass


class PRAKTIKUM_YT_CYPRESS_TO_SOLOMON_BINARY(EDUCATION_WORKFLOW_BINARY):
    pass


# === infrastructure workflows ===

class SCHOOLBOOK_CELERY_STAT_WORKFLOW_BINARY(EDUCATION_WORKFLOW_BINARY):
    pass


class SCHOOLBOOK_COPY_YT_DYNAMIC_TO_YT_STATIC_DB_WORKFLOW_BINARY(EDUCATION_WORKFLOW_BINARY):
    pass


class SCHOOLBOOK_COMPARE_YT_ENVIRONMENTS_WORKFLOW_BINARY(EDUCATION_WORKFLOW_BINARY):
    pass


class SCHOOLBOOK_EMAIL_CERT_MONITORING_WORKFLOW_BINARY(EDUCATION_WORKFLOW_BINARY):
    pass


class SCHOOLBOOK_FAST_DB_WORKFLOW_BINARY(EDUCATION_WORKFLOW_BINARY):
    pass


class SCHOOLBOOK_METRIKA_5MIN_WORKFLOW_BINARY(EDUCATION_WORKFLOW_BINARY):
    pass


class SCHOOLBOOK_METRIKA_LOGS_WORKFLOW_BINARY(EDUCATION_WORKFLOW_BINARY):
    pass


class SCHOOLBOOK_QLOUD_LOGS_TO_SOLOMON_WORKFLOW_BINARY(EDUCATION_WORKFLOW_BINARY):
    pass


class SCHOOLBOOK_OBFUSCATE_KRUZHOK_WORKFLOW_BINARY(EDUCATION_WORKFLOW_BINARY):
    pass


class SCHOOLBOOK_OBFUSCATE_TAAS_WORKFLOW_BINARY(EDUCATION_WORKFLOW_BINARY):
    pass


class SCHOOLBOOK_TAAS_PG_TO_YT_MONITORING_WORKFLOW_BINARY(EDUCATION_WORKFLOW_BINARY):
    pass


class SCHOOLBOOK_SENDER_30MIN_WORKFLOW_BINARY(EDUCATION_WORKFLOW_BINARY):
    pass


class SCHOOLBOOK_SENDER_MONITORING_WORKFLOW_BINARY(EDUCATION_WORKFLOW_BINARY):
    pass


class SCHOOLBOOK_SENDER_WORKFLOW_BINARY(EDUCATION_WORKFLOW_BINARY):
    pass


class SCHOOLBOOK_WEBINAR_TO_YT_WORKFLOW_BINARY(EDUCATION_WORKFLOW_BINARY):
    pass


class SCHOOLBOOK_YT_META_SOLOMON_WORKFLOW_BINARY(EDUCATION_WORKFLOW_BINARY):
    pass


class SCHOOLBOOK_GSHEET_TO_YT_BINARY(EDUCATION_WORKFLOW_BINARY):
    pass


class SCHOOLBOOK_PROD_TO_TESTING_WORKFLOW_BINARY(EDUCATION_WORKFLOW_BINARY):
    pass


# === schoolbook hubble ===
class SCHOOLBOOK_HUBBLE_BINARY(_EducationDockerRelease):
    pass


# === product workflows ===


class SCHOOLBOOK_CRM_FAST_WORKFLOW_BINARY(EDUCATION_WORKFLOW_BINARY):
    pass


class SCHOOLBOOK_CRM_WORKFLOW_BINARY(EDUCATION_WORKFLOW_BINARY):
    pass


class SCHOOLBOOK_EMAIL_CERT_ADD_TASKS_WORKFLOW_BINARY(EDUCATION_WORKFLOW_BINARY):
    pass


class SCHOOLBOOK_EMAIL_CERT_POSTPROCESSOR_WORKFLOW_BINARY(EDUCATION_WORKFLOW_BINARY):
    pass


class SCHOOLBOOK_EMAIL_CERT_PROCESSOR_WORKFLOW_BINARY(EDUCATION_WORKFLOW_BINARY):
    pass


class SCHOOLBOOK_EMAIL_CERT_SCHEDULER_WORKFLOW_BINARY(EDUCATION_WORKFLOW_BINARY):
    pass


# === reactor automation workflows ===


class SCHOOLBOOK_REACTOR_AUTOMATION_BINARY(EDUCATION_WORKFLOW_BINARY):
    pass


class SCHOOLBOOK_ANALYTICS_REACTOR_AUTOMATION_BINARY(EDUCATION_WORKFLOW_BINARY):
    pass


class SCHOOLBOOK_INFRA_REACTOR_AUTOMATION_BINARY(EDUCATION_WORKFLOW_BINARY):
    pass


class SCHOOLBOOK_PRODUCT_REACTOR_AUTOMATION_BINARY(EDUCATION_WORKFLOW_BINARY):
    pass


class EDUCATION_INFRA_REACTOR_AUTOMATION_BINARY(EDUCATION_WORKFLOW_BINARY):
    pass


class PRAKTIKUM_REACTOR_AUTOMATION_BINARY(EDUCATION_WORKFLOW_BINARY):
    pass


# /====================== release machine builds ======================


# ====================== junk ======================

class AGAIBURA_JUNK_BINARY(_EducationStaticResource):
    pass
