# coding: utf-8

from sandbox.projects.common.build.YaMake import YaMakeTask

from sandbox.projects.common.build import parameters as build_params
from sandbox.projects.common.nanny import nanny

import sandbox.projects.epsilond1.resource_types as resource_types

RESOURCES = {
    'test_executable': resource_types.Epsilond1Binary,
}


class BuildEpsilond12(nanny.ReleaseToNannyTask, YaMakeTask):

    type = 'BUILD_EPSILOND12'
    input_parameters = [
        build_params.ArcadiaUrl,
        build_params.BuildType,
        build_params.CheckReturnCode,
        build_params.CheckoutModeParameter,
        build_params.CheckoutParameter
    ]

    def get_resources(self):
        return {
            k: {'description': 'epsilond1_service {}'.format(k), 'resource_path': k, 'resource_type': rtype}
            for k, rtype in RESOURCES.iteritems()
        }

    def get_targets(self):
        return ['junk/epsilond1/test_service']

    def get_arts(self):
        return [{'dest': '', 'path': "{}/{}".format(rtype.arcadia_build_path, k)} for k, rtype in RESOURCES.iteritems()]
