# coding: utf-8

"""
Provides:
    - BuildFromArcadia
"""

from __future__ import division
from __future__ import unicode_literals

from sandbox.projects.common.build.YaMake import YaMakeTask

from sandbox.projects.common.build import parameters as build_params
from sandbox.projects.common.nanny import nanny

__all__ = ('BuildFromArcadia', )


class BuildFromArcadia(nanny.ReleaseToNannyTask, YaMakeTask):
    # Override these in inheritors!
    type = None
    resource_type = None

    input_parameters = [
        build_params.ArcadiaUrl,
        build_params.CheckoutParameter,
        build_params.ClearBuild,
        build_params.TestParameter,
    ]

    execution_space = 1024  # 1Gb

    def get_resources(self):
        return {
            self.resource_type.name: {
                'description': self.resource_type.description,
                'resource_type': self.resource_type,
                'resource_path': '',
            }
        }

    def get_targets(self):
        return [
            self.resource_type.arcadia_build_path
        ]

    def get_arts(self):
        return [
            {'path': self.resource_type.arcadia_build_path}
        ]
