from sandbox import sdk2


class FactorizationLoadYtExecutable(sdk2.Resource):
    executable = True
    releasable = True
    releasers = ['sokursky', 'roizner']


class FactorizationAlsColumnDescriptor(sdk2.Resource):
    auto_backup = True
    any_arch = True


class FactorizationAlsData(sdk2.Resource):
    auto_backup = True
    any_arch = True


class FactorizationAlsFeatureNames(sdk2.Resource):
    auto_backup = True
    any_arch = True


class FactorizationAlsModel(sdk2.Resource):
    auto_backup = True
    any_arch = True


class AlsCommonParams(sdk2.Parameters):
    dimension = sdk2.parameters.Integer("Dimension")
    l2 = sdk2.parameters.Float("Regularization L2")
    lbias = sdk2.parameters.Float("Regularization left bias")
    rbias = sdk2.parameters.Float("Regularization right bias")
    lrexp = sdk2.parameters.Float("Regularization left exponent")
    rrexp = sdk2.parameters.Float("Regularization right exponent")
    implicit = sdk2.parameters.Float("Implicit weight")
    limpexp = sdk2.parameters.Float("Left implicit exponent")
    rimpexp = sdk2.parameters.Float("Right implicit exponent")
    niter = sdk2.parameters.Integer("Number of iterations")
    updateleft = sdk2.parameters.Bool("Update left")
    updateright = sdk2.parameters.Bool("Update right")
    threads = sdk2.parameters.Integer("Num operations", default=4)
    iiter = sdk2.parameters.Integer("Number of inner iterations")
    eps = sdk2.parameters.Float("Convergence epsilon")
    mu = sdk2.parameters.Float("Average target value")
    features = sdk2.parameters.Bool("Extract features")
    with features.value[True]:
        feature_prefix = sdk2.parameters.String("Feature prefix")
    seed = sdk2.parameters.Integer("Seed")
    custom_args = sdk2.parameters.String("Custom arguments")


def add_common_params_to_command(task, command):
    command += ['-j', str(task.Parameters.threads)]
    if task.Parameters.dimension:
        command += ['-d', str(task.Parameters.dimension)]
    if task.Parameters.l2:
        command += ['--reg', str(task.Parameters.l2)]
    if task.Parameters.lbias:
        command += ['--lbias', str(task.Parameters.lbias)]
    if task.Parameters.rbias:
        command += ['--rbias', str(task.Parameters.rbias)]
    if task.Parameters.lrexp:
        command += ['--lrexp', str(task.Parameters.lrexp)]
    if task.Parameters.rrexp:
        command += ['--rrexp', str(task.Parameters.rrexp)]
    if task.Parameters.implicit:
        command += ['--implicit', str(task.Parameters.implicit)]
    if task.Parameters.limpexp:
        command += ['--limpexp', str(task.Parameters.limpexp)]
    if task.Parameters.rimpexp:
        command += ['--rimpexp', str(task.Parameters.rimpexp)]
    if task.Parameters.niter:
        command += ['--iter', str(task.Parameters.niter)]
    if task.Parameters.updateleft:
        command += ['--updateleft']
    if task.Parameters.updateright:
        command += ['--updateright']
    if task.Parameters.iiter:
        command += ['--iiter', str(task.Parameters.iiter)]
    if task.Parameters.eps:
        command += ['--eps', str(task.Parameters.eps)]
    if task.Parameters.mu:
        command += ['--mu', str(task.Parameters.mu)]
    if task.Parameters.seed:
        command += ['--seed', str(task.Parameters.seed)]
    if task.Parameters.custom_args:
        custom_args = task.Parameters.custom_args.strip()
        if custom_args:
            command += custom_args.split()
    return command
