# -*- coding: utf-8 -*-$

import os
import re

from sandbox import sdk2
from sandbox.projects.common import error_handlers as eh


FCONSOLE_RESOURCE_CONFIG_NAME = 'ya.make'
DEFAULT_FCONSOLE_RESOURCE_CONFIG_PATH = 'search/web/rearrs_upper/rearrange.fast/facts/fconsole_data'


class UpdateFconsoleDataResourceInArcadia(sdk2.Task):
    """ Update resource ID in arcadia"""

    class Parameters(sdk2.Parameters):
        resource_id = sdk2.parameters.Integer('FConsole data resource ID', required=True)
        arcadia_config_path = sdk2.parameters.ArcadiaUrl(
            'Path to the config with the resource ID',
            required=True,
            default_value=DEFAULT_FCONSOLE_RESOURCE_CONFIG_PATH
        )
        author = sdk2.parameters.String('Author of commit', default='zomb-sandbox-rw', required=True)

    def on_execute(self):
        svn_url = sdk2.svn.Arcadia.trunk_url(self.Parameters.arcadia_config_path)
        svn_dir = sdk2.svn.Arcadia.get_arcadia_src_dir(svn_url)
        eh.verify(
            svn_dir,
            'Commit directory set by arcadia_config_path parameter should not be None. Path {} may not exist'.format(
                self.Parameters.arcadia_config_path
            )
        )
        svn_dir = str(svn_dir)
        # read lines from the destination file
        lines = []
        with open(os.path.join(svn_dir, FCONSOLE_RESOURCE_CONFIG_NAME), "rt") as _src:
            lines = _src.readlines()
        trg_line_pattern = 'FROM_SANDBOX(FILE {} RENAME facts.txt OUT fact_fconsole_data.tsv)'
        trg_regex = re.compile(trg_line_pattern.format('[0-9]+').replace('(', '\\(').replace(')', '\\)') + '.*')
        # and substitute one by a pattern
        with open(os.path.join(svn_dir, FCONSOLE_RESOURCE_CONFIG_NAME), "wt") as _trg:
            for line in lines:
                if trg_regex.match(line):
                    _trg.write(trg_line_pattern.format(self.Parameters.resource_id) + '\n')
                else:
                    _trg.write(line)
        sdk2.svn.Arcadia.commit(
            svn_dir,
            'Another FConsole fact data resource ({}) committed'.format(self.Parameters.resource_id),
            self.Parameters.author
        )
