import pathlib2
import os

from sandbox.sandboxsdk.environments import TarballToolkitBase

from sandbox.projects.metrika.mobile.sdk.utils import Rvm


# class Rvm(sdk2.Resource):
#    """
#        Resource that holds tarball with installed RVM
#        Originally created by appmetrika team and attributed to them
#        You could see they own version at projects/metrika/mobile/sdk
#    """
#    any_arch = False
#    version = sdk2.Attributes.String("version", required=True)
#    platform = sdk2.Attributes.String("platform", required=True)

class RvmEnvironment(TarballToolkitBase):
    """
        Sandbox environment to work smothly with RVM, originally created by appmetrika team
        RVM: Ruby enVironment Manager
        https://rvm.io/
    """
    resource_type = Rvm
    name = "rvm"
    sys_path_utils = ['rvm', ]

    STABLE = "1.29.3"

    DOT_FILE = ".bash_profile"

    def __init__(self, version=None, **kws):
        super(RvmEnvironment, self).__init__(version or RvmEnvironment.STABLE, **kws)

    def fix_dot_file(self, rvm_dir):
        dot_file = pathlib2.Path.home().joinpath(RvmEnvironment.DOT_FILE)
        self.logger.info("RVM[EVN]: dot file: {}", dot_file)
        if dot_file.exists():
            self.logger.warning("RVM[ENV]: dot file {} exists. Will be overwritten. Content:\n{}", dot_file, dot_file.read_text())

        # TODO: preserve dot_file content

        dot_file_content = "source " + pathlib2.Path(rvm_dir).joinpath("scripts/rvm").as_posix()
        self.logger.info("RVM[ENV]: dot file {} content:\n{}", dot_file, dot_file_content)
        dot_file.write_text(unicode(dot_file_content))

        # TODO: should be close it or flush in some way

    def prepare(self):
        # TODO: check for build environment needness

        env_dir = super(RvmEnvironment, self).prepare()
        bin_dir = os.path.join(env_dir, 'bin')
        self.update_os_path_env(bin_dir)
        self.update_os_env('rvm_bin_path', bin_dir)
        self.update_os_env('rvm_path', env_dir)
        self.update_os_env('rvm_prefix', os.path.dirname(env_dir))
        self.update_os_env('rvm_version', self.version)
        self.update_os_env('SSL_CERT_FILE', os.path.join(env_dir, 'cacert.pem'))
        self.check_environment()
        self.fix_dot_file(env_dir)
        return env_dir
