import logging
# import tempfile

from sandbox import common
from sandbox.sdk2.helpers import subprocess


class Xcode:
    """
        Class to work with sandbox Xcode's and its various things.
    """

    XCODE_PREFIX = "Xcode"

    def __init__(self):
        pass

    def _get_versions(self):
        logging.info("Acquiring versions of Xcode...")

        logging.info("Acquiring installed Xcode's...")
        xcodes = self._run(['ls', '/Applications']).splitlines()
        if not xcodes:
            logging.info("Can not acquire any Xcode in /Applications folder")
            return []

        result = []
        for xcode in xcodes:
            if Xcode.XCODE_PREFIX not in xcode:
                logging.info("app {} is not prefixed with {}, skipped".format(xcode, Xcode.XCODE_PREFIX))
                continue

            xcode_path = "/".join(["/Applications", xcode, "Contents", "Developer", "usr", "bin", "xcodebuild"])
            xcode_version_result = self._run([xcode_path, '-version']).splitlines()
            if not xcode_version_result:
                logging.info("Could not acquire xcode {} version from xcode path {}, skipped.".format(xcode, xcode_path))
                continue

            logging.info("Acquired possible xcode version {}".format("\n".join(xcode_version_result)))

            for item in xcode_version_result:
                if Xcode.XCODE_PREFIX in item:
                    vers = item[len(Xcode.XCODE_PREFIX) + 1:].strip()
                    logging.info("Found {} version of Xcode, here /Applications/{}".format(vers, xcode))
                    result.append(vers)

        return result

    def _run(self, cmd, stdin=None):
        p = subprocess.Popen(cmd, stdout=subprocess.PIPE, stderr=subprocess.PIPE, stdin=subprocess.PIPE if stdin else None)
        stdout, stderr = p.communicate(stdin)

        if p.returncode:
            message = stderr.strip() + "\n" + stdout.strip()
            raise common.errors.TaskError("Can not execute Xcode command {}, because of error: {}".format(" ".join(cmd), message))

        return stdout
