from sandbox import sdk2


class FaviconResourceBase(sdk2.Resource):
    auto_backup = True
    calc_md5 = True
    releasable = True
    releasers = ['niknik', 'esokirkina', 'bvshuryg', 'alexromanov', 'tarum', 'i024', 'salmin', 'robot-testenv', 'robot-favicon', 'd-dolgopolov']
    share = True


class FaviconAttrsDatabase(FaviconResourceBase):
    """
        Runtime favicon database containing attributes
    """
    pass


class FaviconAttrsWadModel(FaviconResourceBase):
    """
        Model for building wad index
    """
    pass


class FaviconDolbiloAmmo(FaviconResourceBase):
    """
        Ammo for dolbilo
    """
    pass


class FaviconCmBinaries(FaviconResourceBase):
    """
    See https://a.yandex-team.ru/arc/trunk/arcadia/robot/favicon/packages/cm_binaries
    """
    arcadia_build_path = 'robot/favicon/packages/cm_binaries'


class FaviconCmConfigs(FaviconResourceBase):
    """
    See https://a.yandex-team.ru/arc/trunk/arcadia/robot/favicon/packages/cm_instances/production
    """
    arcadia_build_path = 'robot/favicon/packages/cm_instances/production'


class FaviconDolbiloBinaries(FaviconResourceBase):
    """
    See https://a.yandex-team.ru/arc/trunk/arcadia/robot/favicon/packages/dolbilo
    """
    arcadia_build_path = 'robot/favicon/packages/dolbilo'


class FaviconWorkerConfig(FaviconResourceBase):
    """
    Bunch of favicon worker configs
    """
    arcadia_build_path = 'robot/favicon/conf/worker'


class FaviconImageImportConfig(FaviconResourceBase):
    """
    Bunch of favicon image_import configs
    """
    arcadia_build_path = 'robot/favicon/conf/image_import'


class FaviconRobotBinary(FaviconResourceBase):
    """
        binary built from robot/favicon
    """
    executable = True
    any_arch = False


class FaviconMakeWadIndex(FaviconRobotBinary):
    """
       cooks runtime wad-based database from YT tables
    """
    arcadia_build_path = 'robot/favicon/tools/make_wad_index/make_wad_index'


class FaviconHttpDaemon(FaviconRobotBinary):
    """
       favicon http daemon
    """
    arcadia_build_path = 'robot/favicon/runtime/favicond'


class FaviconWorker(FaviconRobotBinary):
    """
       favicon worker based on caesar lib
    """
    arcadia_build_path = 'robot/favicon/tools/worker/worker'


class FaviconImageImport(FaviconRobotBinary):
    """
       favicon image import tool based on bigrt lib
    """
    arcadia_build_path = 'robot/favicon/tools/image_import/image_import'


class PortoLayerFonts(FaviconResourceBase):
    """
        Fonts for SVG converting. See robot/favicon/porto_layer/fonts.sh for details.
    """
    pass
