from sandbox import sdk2

releasers = ["mvel", "robot-srch-releaser", "robot-testenv", "saku", "coffeeman", "i024", "andreippv"]


class FindurlPackage(sdk2.Resource):
    """
       Findurl ya_package
    """
    releasable = True
    auto_backup = True
    releasers = releasers


class FindurlBinary(sdk2.Resource):
    """
    Findurl binary.
    """
    releasable = True
    any_arch = False
    releasers = releasers
    auto_backup = True
    arcadia_build_path = "search/tools/findurl/bin/findurl"


class FindurlComparisonFile(sdk2.Resource):
    """
    Findurl comparison file.
    """


class FindurlResponse1(sdk2.Resource):
    """
    Keeps findurl first response
    """


class FindurlResponse2(sdk2.Resource):
    """
    Keeps findurl second response
    """
