# coding: utf-8
from sandbox import sdk2

import sandbox.projects.resource_types.releasers as releasers

# for backward compatibility, do not use it, use sdk2.Resource instead
AbstractResource = sdk2.resource.AbstractResource


class FINTECH_FALLBACK_PROXY_BACKEND(AbstractResource):
    """
        FINTECH_FALLBACK_PROXY_BACKEND related resource
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = releasers.fintech_risk_releasers
    arcadia_build_path = 'kernel/common_server/solutions/fallback_proxy/src'


class FintechFallbackProxyResourceBase(sdk2.Resource):
    releasable = True
    releasers = ["mennibaev", "robot-srch-releaser"]


class FINTECH_FALLBACK_PROXY_CONFIG_STABLE(FintechFallbackProxyResourceBase):
    pass


class FINTECH_FALLBACK_PROXY_CONFIG(FintechFallbackProxyResourceBase):
    pass


class FINTECH_FALLBACK_PROXY_MIGRATIONS(FintechFallbackProxyResourceBase):
    pass


class FINTECH_FALLBACK_PROXY_RESOURCES_PACK(FintechFallbackProxyResourceBase):
    pass
