# coding: utf-8
from sandbox import sdk2

import sandbox.projects.resource_types.releasers as releasers

# for backward compatibility, do not use it, use sdk2.Resource instead
AbstractResource = sdk2.resource.AbstractResource


class FINTECH_OPERRISK_BACKEND(AbstractResource):
    """
        FINTECH_OPERRISK_BACKEND related resource
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = releasers.fintech_risk_releasers
    arcadia_build_path = 'fintech/risk/operrisk/src'


class FintechOperriskResourceBase(sdk2.Resource):
    releasable = True
    releasers = ["ivanmorozov", "starodub", "alrakov", "robot-srch-releaser"]


class FINTECH_OPERRISK_CONFIG_STABLE(FintechOperriskResourceBase):
    pass


class FINTECH_OPERRISK_CONFIG(FintechOperriskResourceBase):
    pass


class FINTECH_OPERRISK_MIGRATIONS(FintechOperriskResourceBase):
    pass
