# coding: utf-8
from sandbox import sdk2

import sandbox.projects.resource_types.releasers as releasers

# for backward compatibility, do not use it, use sdk2.Resource instead
AbstractResource = sdk2.resource.AbstractResource


class FINTECH_RISK_BACKEND(AbstractResource):
    """
        FINTECH_RISK_BACKEND related resource
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = releasers.fintech_risk_releasers
    arcadia_build_path = 'fintech/risk/backend/src'


class FintechRiskResourceBase(sdk2.Resource):
    releasable = True
    releasers = ["ivanmorozov", "robot-srch-releaser"]


class FINTECH_RISK_RESOURCES_PACK(FintechRiskResourceBase):
    pass
