# coding: utf-8
from sandbox import sdk2

import sandbox.projects.resource_types.releasers as releasers

# for backward compatibility, do not use it, use sdk2.Resource instead
AbstractResource = sdk2.resource.AbstractResource


class FINTECH_RISK_SOURCES(AbstractResource):
    """
        FINTECH_RISK_SOURCES related resource
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = releasers.fintech_risk_releasers
    arcadia_build_path = 'fintech/risk/sources/core/src'


class FintechRiskSourcesResourceBase(sdk2.Resource):
    releasable = True
    releasers = ["alrakov", "robot-srch-releaser"]


class FINTECH_RISK_SOURCES_CONFIG(FintechRiskSourcesResourceBase):
    pass


class FINTECH_RISK_SOURCES_MIGRATIONS(FintechRiskSourcesResourceBase):
    pass


class FINTECH_RISK_SOURCES_EXTERNAL_DATA(FintechRiskSourcesResourceBase):
    pass


class FINTECH_RISK_SOURCES_RESOURCES_PACK(FintechRiskSourcesResourceBase):
    pass
