# -*- coding: utf-8 -*-

import sandbox.common.types.client as ctc
from sandbox.projects.common.build.CommonBuildTask import CommonBuildTask

from sandbox import sdk2
AbstractResource = sdk2.resource.AbstractResource


class FML_MR_LT_SPLITTER_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл mr_lt_splitter
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['qdeee', 'ksenon']


class BuildFmlMrLtSplitter(CommonBuildTask):
    """
        building binary for BUILD_FML_MR_LT_SPLITTER task
    """

    type = 'BUILD_FML_MR_LT_SPLITTER'

    client_tags = ctc.Tag.Group.LINUX

    TARGET_RESOURCES = (
        (FML_MR_LT_SPLITTER_EXECUTABLE, 'quality/relev_tools/fml_mr_utils/mr_lt_splitter/mr_lt_splitter'),
    )


__Task__ = BuildFmlMrLtSplitter
