# -*- coding: utf-8 -*-

import sandbox.common.types.client as ctc
from sandbox.projects.common.build.CommonBuildTask import CommonBuildTask

from sandbox import sdk2
AbstractResource = sdk2.resource.AbstractResource


class FML_MR_POOL_STATS_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл mr_pool_statistics
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['qdeee', 'sancho', 'ksenon']


class BuildFmlMrPoolStats(CommonBuildTask):
    """
        building binary for BUILD_FML_MR_POOL_STATS task
    """

    type = 'BUILD_FML_MR_POOL_STATS'

    client_tags = ctc.Tag.Group.LINUX

    TARGET_RESOURCES = (
        (FML_MR_POOL_STATS_EXECUTABLE, 'quality/relev_tools/fml_mr_utils/mr_pool_statistics/mr_pool_statistics'),
    )


__Task__ = BuildFmlMrPoolStats
