# coding: utf8

from sandbox import sdk2
import datetime


class DeleteObsoletePages(sdk2.Task):
    class Parameters(sdk2.Parameters):
        endpoint = sdk2.parameters.String('endpoint', required=True)
        database = sdk2.parameters.String('database', required=True)
        path = sdk2.parameters.String('path', required=True)

    def on_execute(self):
        import ydb

        owner, secret_name = 'luckydenis', 'YDB_TOKEN'

        class YDB(object):
            def __init__(self, endpoint, database, token, path):
                self._endpoint = str(endpoint)
                self._database = str(database)
                self._token = str(token)
                self._path = str(path)
                self.session = self._open_session()

            def _open_session(self):
                return self._create_driver().table_client.session().create()

            def _connection_params(self):
                return ydb.ConnectionParams(
                    endpoint=self._endpoint,
                    database=self._database,
                    auth_token=self._token
                )

            def _create_driver(self):
                driver = ydb.Driver(self._connection_params())
                driver.wait(5)
                return driver

            def _get_timestamp(self):
                dt = datetime.datetime.today() - datetime.timedelta(days=1)
                return int(dt.strftime('%s'))

            def delete_obsolete_pages(self):
                query = """
                        PRAGMA TablePathPrefix("{path}");

                        DECLARE $timestamp_ AS Uint64;

                        DELETE FROM context_items
                        WHERE timestamp < $timestamp_;
                        """.format(path=self._path)

                prepared_query = self.session.prepare(query)

                self.session.transaction(ydb.SerializableReadWrite()).execute(
                    prepared_query, {
                        '$timestamp_': self._get_timestamp(),
                    },
                    commit_tx=True
                )

        database = YDB(
            endpoint=self.Parameters.endpoint,
            database=self.Parameters.database,
            token=sdk2.Vault.data(owner, secret_name),
            path=self.Parameters.path
        )

        database.delete_obsolete_pages()
