# -*- coding: utf-8 -*-

from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess as sp


freshness_releasers = [
    'epar',
    'iv-ivan',
    'melton',
    'nkmakarov',
    'ustas',
    'zhevnerchuk'
]


class FreshnessExternalScripts(sdk2.Resource):
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = freshness_releasers


class BuildFreshnessExternalScripts(sdk2.Task):

    class Parameters(sdk2.Task.Parameters):
        revision = sdk2.parameters.Integer('Arcadia revision number', required=True)
        paths = sdk2.parameters.List('Arcadia paths', required=True)

    def on_execute(self):
        archive_folder = sdk2.path.Path('out')
        archive_folder.mkdir()

        for path in self.Parameters.paths:
            sdk2.svn.Arcadia.export(
                sdk2.svn.Arcadia.trunk_url(path),
                str(archive_folder),
                revision=self.Parameters.revision
            )

        resource_filename = 'freshness-external-scripts.tar.gz'

        with sdk2.helpers.ProcessLog(self, logger="tar") as pl:
            sp.check_call("tar -C {folder} -zcf {name} .".format(folder=str(archive_folder), name=resource_filename),
                          shell=True, stdout=pl.stdout, stderr=sp.STDOUT)

        resource = sdk2.ResourceData(FreshnessExternalScripts(self, "Freshness external scripts", resource_filename))
        resource.path.write_bytes(sdk2.path.Path(resource_filename).read_bytes())
        resource.ready()
