import logging

from sandbox import sdk2

from sandbox.projects.common import error_handlers as eh


class UpdateGeoDataUsagesTask(sdk2.Task):
    """ Updates ya.make file that uses GEODATA_TREE_LING_STABLE resource with newest version """

    class Parameters(sdk2.Task.Parameters):
        target_path = sdk2.parameters.String('Target directory with ya.make file',
                                             default='/search/web/rearrs_upper/rearrange/toponym_wizard', required=True)
        author = sdk2.parameters.String('Author of commit', default='zomb-sandbox-rw', required=True)
        resource_file_name = sdk2.parameters.String('Geodata file name', default='geodata4-tree+ling.bin', required=True)

    def on_execute(self):
        resource = sdk2.Resource["GEODATA_TREE_LING_STABLE"].find(attrs=dict(released='stable')).first()

        if not resource.description.startswith("'" + self.Parameters.resource_file_name):
            logging.error("Description format have changed, something is probably wrong!")
            raise Exception("Resource description is different")

        svn_url = sdk2.svn.Arcadia.trunk_url(self.Parameters.target_path)
        svn_dir = sdk2.svn.Arcadia.get_arcadia_src_dir(svn_url)
        eh.verify(
            svn_dir, "Directory set by target_path parameter should not be None. Maybe path {} does not exist".format(
                self.Parameters.target_path
            )
        )
        svn_dir = str(svn_dir)

        filename = svn_dir + "/ya.make"
        filedata = ""
        need_to_commit = False
        with open(filename, 'r') as file:
            for line in file:
                if ('geodata4-tree+ling.bin' in line) and ('FROM_SANDBOX' in line):
                    new_line = "FROM_SANDBOX(FILE {} OUT {})\n".format(resource.id, self.Parameters.resource_file_name)
                    if new_line != line:
                        line = new_line
                        need_to_commit = True
                filedata = filedata + line

        if not need_to_commit:
            logging.info("Geodata has not changed since last run, nothing to commit. Exiting...")
            return

        with open(filename, 'w') as file:
            file.write(filedata)
        comment = "{} update geodata with new id:{}\nhttps://sandbox.yandex-team.ru/task/{}/view\nSKIP_CHECK".format(self.type, resource.id, self.id)

        sdk2.svn.Arcadia.commit(svn_dir, comment, self.Parameters.author)
