import logging
import json

from sandbox import sdk2

from sandbox.common.errors import TaskFailure


class UpdateTvFastData(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        pass

    def compare_resources(self, id1, id2):
        r1 = sdk2.ResourceData(sdk2.Resource.find(id=id1).first())
        r2 = sdk2.ResourceData(sdk2.Resource.find(id=id2).first())
        with open(str(r1.path)) as f:
            t1 = json.loads('\n'.join(f.readlines()))
        with open(str(r2.path)) as f:
            t2 = json.loads('\n'.join(f.readlines()))
        return t1 == t2

    def on_execute(self):
        resource = sdk2.Resource["OTHER_RESOURCE"].find(attrs=dict(tv_show_fast_data='1')).first()
        resource_data = sdk2.ResourceData(resource)
        resource_path = str(resource_data.path)
        try:
            with open(resource_path) as f:
                json.loads(' '.join(f.readlines()))
        except:
            logging.info("resource is broken or otherwise unavailable")
            return
        if not resource_path.endswith("tv_shows_for_fast"):
            logging.info("filename has probably changed to " + resource_path)
            return

        svn_url = sdk2.svn.Arcadia.trunk_url('/search/web/rearrs_upper/rearrange.fast/tv_broadcast')
        svn_dir = sdk2.svn.Arcadia.get_arcadia_src_dir(svn_url)
        svn_dir = str(svn_dir)

        filename = svn_dir + "/ya.make"
        filedata = ""
        need_to_commit = False
        with open(filename, 'r') as file:
            for line in file:
                if 'tv_shows_for_fast' in line and "FROM_SANDBOX" in line:
                    other_resource_id = line.split("FROM_SANDBOX(FILE ")[1].split(" OUT")[0]
                    if not self.compare_resources(resource.id, other_resource_id):
                        line = "FROM_SANDBOX(FILE {} OUT tv_shows_for_fast)\n".format(resource.id)
                        need_to_commit = True
                    else:
                        logging.info("Data is same")
                filedata = filedata + line

        if not need_to_commit:
            logging.info("No need to commit")
            return

        with open(filename, 'w') as file:
            file.write(filedata)

        comment = "{} update tv data with new id:{}\nhttps://sandbox.yandex-team.ru/task/{}/view".format(self.type, resource.id, self.id)
        commit_result = sdk2.svn.Arcadia.commit(svn_dir, comment, 'zomb-sandbox-rw')
        if not commit_result:
            raise TaskFailure('Empty commit result')
        self.set_info('Done commit with result: {}'.format(commit_result))
