# -*- coding: utf-8 -*-
import hashlib


def checksum(filename, bufsize=128*1024):
    sha256 = hashlib.sha256()
    mv = memoryview(bytearray(bufsize))

    with open(filename, 'rb', buffering=0) as f:
        for n in iter(lambda : f.readinto(mv), 0):
            sha256.update(mv[:n])

    return sha256.hexdigest()
