from sandbox import sdk2


class FuzzyQueries(sdk2.Resource):
    """Common resource type for fuzzy queries (tar.gz)"""
    any_arch = True
    auto_backup = True
    last_fuzzed_queries = sdk2.parameters.String("Last fuzzed attr time")


class PlainTextQueriesFuzzy(FuzzyQueries):
    """Tar.gz archive of files with queries for basesearch fuzzer"""


class BegemotQueriesFuzzy(FuzzyQueries):
    """Tar.gz archive of files with queries for begemot fuzzer"""


class VideoBasesearchQueriesFuzzy(FuzzyQueries):
    """Tar.gz archive of files with queries for middlesearch fuzzer"""


class WebMiddlesearchQueriesFuzzy(FuzzyQueries):
    """Tar.gz archive of files with queries for middlesearch fuzzer"""


class WebBlenderQueriesFuzzy(FuzzyQueries):
    """Tar.gz archive of files with queries for blender fuzzer"""


class WizardQueriesFuzzy(FuzzyQueries):
    """Tar.gz archive of files with queries for wizard fuzzer"""


class FuzzyProblemQueries(sdk2.Resource):
    any_arch = True
    auto_backup = True
    last_problem_queries = sdk2.parameters.String("Problem name")


# crashes


class FuzzyBasesearchCrashQueries(FuzzyProblemQueries):
    """Folder with basesearch fuzzy crashes queries"""


class FuzzyBegemotCrashQueries(FuzzyProblemQueries):
    """Folder with begemot fuzzy crashes queries"""


class FuzzyVideoBasesearchCrashQueries(FuzzyProblemQueries):
    """Folder with basesearch fuzzy crashes queries"""


class FuzzyMiddlesearchCrashQueries(FuzzyProblemQueries):
    """Folder with middlesearch fuzzy crashes queries"""


class FuzzyBlenderCrashQueries(FuzzyProblemQueries):
    """Folder with blender fuzzy crashes queries"""


class FuzzyWizardCrashQueries(FuzzyProblemQueries):
    """Folder with wizard fuzzy crashes queries"""


# slow-units


class FuzzyBasesearchSlowUnitQueries(FuzzyProblemQueries):
    """Folder with basesearch fuzzy slow-unit queries"""


class FuzzyBegemotSlowUnitQueries(FuzzyProblemQueries):
    """Folder with begemot fuzzy slow-unit queries"""


class FuzzyVideoBasesearchSlowUnitQueries(FuzzyProblemQueries):
    """Folder with basesearch fuzzy slow-unit queries"""


class FuzzyMiddlesearchSlowUnitQueries(FuzzyProblemQueries):
    """Folder with middlesearch fuzzy slow-unit queries"""


class FuzzyBlenderSlowUnitQueries(FuzzyProblemQueries):
    """Folder with blender fuzzy slow-unit queries"""


class FuzzyWizardSlowUnitQueries(FuzzyProblemQueries):
    """Folder with wizard fuzzy slow-unit queries"""


# timeouts


class FuzzyBasesearchTimeoutQueries(FuzzyProblemQueries):
    """Folder with basesearch fuzzy timeout queries"""


class FuzzyBegemotTimeoutQueries(FuzzyProblemQueries):
    """Folder with begemot fuzzy timeout queries"""


class FuzzyVideoBasesearchTimeoutQueries(FuzzyProblemQueries):
    """Folder with basesearch fuzzy timeout queries"""


class FuzzyMiddlesearchTimeoutQueries(FuzzyProblemQueries):
    """Folder with middlesearch fuzzy timeout queries"""


class FuzzyBlenderTimeoutQueries(FuzzyProblemQueries):
    """Folder with blender fuzzy timeout queries"""


class FuzzyWizardTimeoutQueries(FuzzyProblemQueries):
    """Folder with wizard fuzzy timeout queries"""


# ooms


class FuzzyBasesearchOomQueries(FuzzyProblemQueries):
    """Folder with basesearch fuzzy oom queries"""


class FuzzyBegemotOomQueries(FuzzyProblemQueries):
    """Folder with begemot fuzzy oom queries"""


class FuzzyVideoBasesearchOomQueries(FuzzyProblemQueries):
    """Folder with basesearch fuzzy oom queries"""


class FuzzyMiddlesearchOomQueries(FuzzyProblemQueries):
    """Folder with middlesearch fuzzy oom queries"""


class FuzzyBlenderOomQueries(FuzzyProblemQueries):
    """Folder with blender fuzzy oom queries"""


class FuzzyWizardOomQueries(FuzzyProblemQueries):
    """Folder with wizard fuzzy oom queries"""


# mismatches


class FuzzyBasesearchMismatchQueries(FuzzyProblemQueries):
    """Folder with basesearch fuzzy mismatch queries"""


class FuzzyBegemotMismatchQueries(FuzzyProblemQueries):
    """Folder with begemot fuzzy mismatch queries"""


class FuzzyVideoBasesearchMismatchQueries(FuzzyProblemQueries):
    """Folder with basesearch fuzzy mismatch queries"""


class FuzzyMiddlesearchMismatchQueries(FuzzyProblemQueries):
    """Folder with middlesearch fuzzy mismatch queries"""


class FuzzyBlenderMismatchQueries(FuzzyProblemQueries):
    """Folder with blender fuzzy mismatch queries"""


class FuzzyWizardMismatchQueries(FuzzyProblemQueries):
    """Folder with wizard fuzzy mismatch queries"""


# leaks


class FuzzyBasesearchLeakQueries(FuzzyProblemQueries):
    """Folder with basesearch fuzzy leak queries"""


class FuzzyBegemotLeakQueries(FuzzyProblemQueries):
    """Folder with begemot fuzzy leak queries"""


class FuzzyVideoBasesearchLeakQueries(FuzzyProblemQueries):
    """Folder with basesearch fuzzy leak queries"""


class FuzzyMiddlesearchLeakQueries(FuzzyProblemQueries):
    """Folder with middlesearch fuzzy leak queries"""


class FuzzyBlenderLeakQueries(FuzzyProblemQueries):
    """Folder with blender fuzzy leak queries"""


class FuzzyWizardLeakQueries(FuzzyProblemQueries):
    """Folder with wizard fuzzy leak queries"""


class SanitizerFuzzyCoverage(sdk2.Resource):
    """Coverage for fuzzer"""
    any_arch = True
    auto_backup = True
    fuzzer_type = sdk2.parameters.String("Fuzzer type")
