from sandbox import sdk2
from sandbox.projects.gamma.common.package import BuildGammaPackage
from sandbox.projects.gamma.common.resources import GammaServerPackage


class BuildGammaServerPackage(BuildGammaPackage):
    """
    Task builds gamma server package
    """

    class Requirements(sdk2.Task.Requirements):
        disk_space = 1000

    class Parameters(BuildGammaPackage.Parameters):
        gamma_package = sdk2.parameters.String(
            'Gamma server package', default="alice/gamma/config/server/packages/server-package.json", required=True,
        )

    def on_execute(self):
        arcadia_url = self.get_arcadia_url()
        task_description = "YaPackage subtask of BuildGammaServerPackage; parent task_id={id}".format(id=self.id)

        with self.memoize_stage.subtask_launch:
            package = GammaServerPackage(self, "Build from {url}".format(url=arcadia_url), "package")
            self.build_package(
                task_description=task_description,
                arcadia_url=arcadia_url,
                path_to_package=self.Parameters.gamma_package,
                resource_type=GammaServerPackage.name,
                resource=package,
            )
