from sandbox import sdk2
from sandbox.projects.gamma.common.package import BuildGammaPackage
from sandbox.projects.gamma.common.resources import GammaSkillPackage


class BuildGammaSkillPackage(BuildGammaPackage):
    """
    Task builds gamma skill package
    """

    class Requirements(sdk2.Task.Requirements):
        disk_space = 1000

    class Parameters(BuildGammaPackage.Parameters):
        skill_id = sdk2.parameters.String('Gamma skill id', default='echo', required=True)
        skill_package = sdk2.parameters.String(
            'Gamma skill package', default="alice/gamma/config/skills/echo/echo-package.json", required=True,
        )

    def on_execute(self):
        arcadia_url = self.get_arcadia_url()
        task_description = "YaPackage subtask of BuildGammaSkillPackage; parent task_id={id}, skill={skill}".format(
            id=self.id, skill=self.Parameters.skill_id,
        )

        with self.memoize_stage.subtask_launch:
            package = GammaSkillPackage(
                self, "Build from {url}".format(url=arcadia_url), "package", skill_id=self.Parameters.skill_id
            )
            self.build_package(
                task_description=task_description,
                arcadia_url=arcadia_url,
                path_to_package=self.Parameters.skill_package,
                resource_type=GammaSkillPackage.name,
                resource=package,
            )
