from sandbox import sdk2
from sandbox.common.types import task
from sandbox.projects.common.nanny import nanny


class BuildGammaPackage(nanny.ReleaseToNannyTask2, sdk2.Task):
    """
    Abstract task that builds gamma packages
    """

    class Parameters(sdk2.Task.Parameters):
        arcadia_url = sdk2.parameters.ArcadiaUrl('Svn url for arcadia', required=True)
        revision = sdk2.parameters.String('Revision')
        use_aapi_fuse = sdk2.parameters.Bool('Use ArcadiaApi FUSE')

    def get_arcadia_url(self):
        if not self.Parameters.revision:
            return self.Parameters.arcadia_url
        return '{url}@{rev}'.format(url=self.Parameters.arcadia_url, rev=self.Parameters.revision)

    def build_package(self, arcadia_url, path_to_package, resource_type, resource, task_description):
        build_task = sdk2.Task["YA_PACKAGE"](
            self,
            description=task_description,
            checkout_arcadia_from_url=arcadia_url,
            use_aapi_fuse=self.Parameters.use_aapi_fuse,
            package_type='tarball',
            use_new_format=True,
            packages=path_to_package,
            resource_type=resource_type,
            resource_id=str(resource.id)
        ).enqueue()

        self.Context.subtask_id = build_task.id
        raise sdk2.WaitTask([build_task], task.Status.Group.FINISH, wait_all=True)

    def on_execute(self):
        pass

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask2.on_release(self, additional_parameters)
        sdk2.Task.on_release(self, additional_parameters)
