from sandbox import sdk2
from sandbox.projects.garden.common import garden_releasers


class YtGardenModuleBinaryResource(sdk2.resource.AbstractResource):
    """
    Garden module binary in YT
    """
    releasable = True
    auto_backup = True
    any_arch = False
    # Attributes for RM/SEDEM
    branch = ""
    resource_name = ""
    svn_revision = 0
    arc_commit = ""


class MapsGardenDataValidationReport(sdk2.Resource):
    """
    Autotests report generated by a Garden module
    """
    module_name = ""
    contour = ""
    environment = ""


class MapsGardenToolsGardenCli(sdk2.Resource):
    """
    Garden CLI binary
    """
    releasable = True
    releasers = garden_releasers
    executable = True
    any_arch = False
    ttl = "inf"


class MapsGardenCliLauncherPackage(sdk2.Resource):
    """
    Debian package for maps/garden/tools/garden_cli_launcher
    """
    releasable = True
    releasers = garden_releasers


class MapsGardenPlaygroundToolsPackage(sdk2.Resource):
    """
    Debian package for maps/garden/tools/playground
    """
    releasable = True
    releasers = garden_releasers
