from sandbox import sdk2


class GeminiResourceBase(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = ['grmammaev', 'bvshuryg', 'vlavrenchenko']
    ttl = 100


class GeminiSearchproxyBinary(GeminiResourceBase):
    """
    target https://a.yandex-team.ru/arc/trunk/arcadia/robot/gemini/packages/searchproxy
    package consists of https://a.yandex-team.ru/arc/trunk/arcadia/saas/searchproxy
    """
    executable = True


class GeminiGeneralConfig(GeminiResourceBase):
    """
    target https://a.yandex-team.ru/arc/trunk/arcadia/robot/gemini/packages/gemini_config
    package consists of https://a.yandex-team.ru/arc/trunk/arcadia/robot/gemini/configs/gemini.cfg
    """
    pass


class GeminiQuoterConfig(GeminiResourceBase):
    """
    target https://a.yandex-team.ru/arc/trunk/arcadia/robot/gemini/packages/quota_config
    package consists of ttps://a.yandex-team.ru/arc/trunk/arcadia/robot/gemini/configs/squota.gemini.xml
    """
    pass


class GeminiSearchproxyConfig(GeminiResourceBase):
    """
    target https://a.yandex-team.ru/arc/trunk/arcadia/robot/gemini/packages/proxy_config
    package consists of https://a.yandex-team.ru/arc/trunk/arcadia/robot/gemini/configs/searchproxy-gemini.conf
    """
    pass


class GeminiViewerBinary(GeminiResourceBase):
    """
    target https://a.yandex-team.ru/arc/trunk/arcadia/robot/gemini/packages/viewer
    package consists of https://a.yandex-team.ru/arc/trunk/arcadia/robot/gemini/viewer
    """
    executable = True
