import os
import subprocess

from sandbox.common.types.client import Tag
from sandbox import sdk2
from sandbox import sandboxsdk


class SaaSConfigsDirectory(sdk2.Resource):
    """
        SaaS configs directory
    """


class ConfigsDirectory(sdk2.Resource):
    """
        Configs directory
    """


class BuildConfigsViaApi(sdk2.Task):
    """ Build api configs task. """

    class Requirements(sdk2.Task.Requirements):
        client_tags = Tag.CUSTOM_GENCFG_BUILD
        disk_space = 50000

    class Parameters(sdk2.Task.Parameters):
        configs = sdk2.parameters.List("list of configs to build", default=["media-balancers"])
        tag = sdk2.parameters.String("tag", default="trunk")

    def on_execute(self):
        if self.Parameters.tag == "trunk":
            sdk2.svn.Arcadia.checkout("svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/gencfg", ".")
        else:
            sdk2.svn.Arcadia.checkout("svn+ssh://arcadia.yandex.ru/arc/tags/gencfg/{}".format(self.Parameters.tag), '.')
        sdk2.svn.Arcadia.export("svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/ya", '.')
        generators = []
        configs_to_build = set([i for i in self.Parameters.configs])
        with sandboxsdk.environments.VirtualEnvironment(do_not_remove=True) as venv:
            sandboxsdk.environments.PipEnvironment("sepelib", version="0.5.189a4", use_wheel=True, venv=venv).prepare()
            my_env = os.environ.copy()
            my_env["CUSTOM_PYTHON"] = venv.executable
            my_env["PATH"] = "$PWD:" + os.environ["PATH"]
            my_env['GENCFG_DEFAULT_OAUTH'] = sdk2.Vault.data('GENCFG', 'gencfg_default_oauth')
            loggers = []

            if "l7" in configs_to_build:
                loggers.append(sdk2.helpers.ProcessLog(self, logger="l7"))
                generators.append(
                    subprocess.Popen(["time", "bash", "./custom_generators/balancer_gencfg/gen-configs-l7-balancer.sh", "api"], stdout=loggers[-1].stdout, stderr=loggers[-1].stderr, env=my_env)
                )
            if "media-balancers" in configs_to_build:
                loggers.append(sdk2.helpers.ProcessLog(self, logger="media-balancers"))
                generators.append(
                    subprocess.Popen(["time", "bash", "./custom_generators/balancer_gencfg/gen-configs-media-balancers.sh", "api"], stdout=loggers[-1].stdout, stderr=loggers[-1].stderr, env=my_env)
                )
            if "improxy" in configs_to_build:
                loggers.append(sdk2.helpers.ProcessLog(self, logger="improxy"))
                cmd = ["time", "bash", "./custom_generators/balancer_gencfg/gen-configs-improxy.sh", "api"]
                if self.Parameters.tag != "trunk":
                    cmd.append(self.Parameters.tag)
                generators.append(
                    subprocess.Popen(cmd, stdout=loggers[-1].stdout, stderr=loggers[-1].stderr, env=my_env)
                )
            if "saas" in configs_to_build:
                if not os.path.isdir('w-generated'):
                    os.makedirs('w-generated')
                if not os.path.isdir('w-generated/all'):
                    os.makedirs('w-generated/all')
                loggers.append(sdk2.helpers.ProcessLog(self, logger="saas"))
                generators.append(
                    subprocess.Popen(["time", "bash", "./scripts/gen-configs-saas.sh"], stdout=loggers[-1].stdout, stderr=loggers[-1].stderr, env=my_env)
                )
            for idx, p in enumerate(generators):
                p.communicate()
                if p.returncode:
                    self.set_info(loggers[idx].stderr.path.open().read())
                    assert p.returncode == 0
            for configdir in os.listdir('custom_generators/balancer_gencfg/generated'):
                os.rename("custom_generators/balancer_gencfg/generated/{}".format(configdir), "generated/{}".format(configdir))
            resource = sdk2.ResourceData(ConfigsDirectory(self, "configs", "generated"))
            resource.ready()
            if "saas" in configs_to_build:
                saas_resource = sdk2.ResourceData(ConfigsDirectory(self, "saas-configs", "w-generated"))
                saas_resource.ready()
