import os

from sandbox.projects.common.build.parameters import get_arcadia_params
from sandbox.projects.common.build.YaMake import YaMakeTask, ya_make_build_params
from sandbox.projects.resource_types import AbstractResource


class CLUSTERSTATE_PROGRAMS(AbstractResource):
    """
        All clusterstate programs (clusterstate, psi, hostinfo, ...)
    """
    releasable = True
    auto_backup = True
    executable = True
    arcadia_build_path = 'infra/clusterstate'


class BuildInfraClusterstate(YaMakeTask):
    """ Build all clusterstate programs"""

    type = 'BUILD_INFRA_CLUSTERSTATE'
    input_parameters = ya_make_build_params() + get_arcadia_params()
    execution_space = 4 * 1024

    def get_resources(self):
        resources = {
            'description': 'All clusterstate executables',
            'resource_path': os.path.basename(CLUSTERSTATE_PROGRAMS.arcadia_build_path),
            'resource_type': CLUSTERSTATE_PROGRAMS,
        }
        return {'project': resources}

    def get_targets(self):
        return [CLUSTERSTATE_PROGRAMS.arcadia_build_path]

    def get_arts(self):
        return [{'path': CLUSTERSTATE_PROGRAMS.arcadia_build_path}]


__Task__ = BuildInfraClusterstate
