# coding: utf8

import json
from datetime import date


import sandbox.common.types.misc as ctm
from sandbox import sdk2
from sandbox.sandboxsdk import environments
from sandbox.projects.common.gencfg import utils as config_generator_utils

import sandbox.projects.gencfg.environment as environment


class DumpGroupsDataToYT(sdk2.Task):
    """Dump groups data to YT (GENCFG-4456)"""

    class Requirements(sdk2.Task.Requirements):
        ramdrive = ctm.RamDrive(ctm.RamDriveType.TMPFS, 10 * 1024, None)
        environments = [
            environments.PipEnvironment('yandex-yt'),
        ]

    def on_execute(self):
        import yt.wrapper as yt
        config_generator_utils.clone_gencfg_repo(config_generator_utils.GENCFG_TRUNK_SRC_PATH, self.get_trunk_path())

        gencfg = environment.GencfgEnvironment(self, None, self.get_trunk_path())
        gencfg.prepare()
        gencfg.install()

        token = sdk2.Vault.data('METERING', 'METERING_TOKEN')

        command = "./utils/common/dump_group_resources.py"
        output_str = gencfg.run_process_output(command, 'dump_groups_data_to_yt')

        output_json = json.loads(output_str)

        gb_to_b = 1024 * 1024 * 1024
        yt_rows = []
        for group in output_json:
            for dc, dc_data in group["resources_per_dc"].iteritems():
                fromatted_row = {
                    "account_id": group["account_id"],
                    "group_name": group["group_name"],
                    "is_rtc_group": True,  # Is always true, not a mistake
                    "dc": dc,
                    "cpu": int(dc_data["cpu"]),
                    "memory": int(dc_data["mem"] * gb_to_b),
                    "hdd_storage": int(dc_data["hdd"] * gb_to_b),
                    "ssd_storage": int(dc_data["ssd"] * gb_to_b)
                }
                yt_rows.append(fromatted_row)

        yt.config["pickling"]["module_filter"] = lambda module: "hashlib" not in getattr(module, "__name__", "") and getattr(module, "__name__", "") != "hmac"
        yt.config['token'] = token
        yt.config.set_proxy("hahn")

        yt_dir = "//home/data_com/cubes/gencfg/groups_data"
        today = date.today().strftime("%Y-%m-%d")
        yt.write_table(yt_dir + "/" + today, yt_rows, yt.JsonFormat())

    def get_trunk_path(self):
        return self.ramdrive.path / 'trunk'
