# coding: utf8
import os
import sandbox.common.types.misc as ctm
import sandbox.common.types.client as ctc
import sandbox.projects.gencfg.environment as environment

from sandbox import sdk2
from sandbox.common.errors import TaskFailure
from sandbox.projects.resource_types import CONFIG_BUILD_LOGS


class GencfgGroupsHbfInfo(sdk2.Resource):
    """
        JSON with map group_name -> group_hbf_info
    """
    releasable = True
    executable = False
    auto_backup = True


class GencfgDumpGroupsHbfInfo(sdk2.Task):
    """ Check revision and dump groups hbf info """

    class Context(sdk2.Task.Context):
        gencfg_revision = 0

    class Requirements(sdk2.Task.Requirements):
        ramdrive = ctm.RamDrive(ctm.RamDriveType.TMPFS, 10 * 1024, None)
        client_tags = ctc.Tag.CUSTOM_GENCFG_BUILD

    class Parameters(sdk2.Task.Parameters):
        revision = sdk2.parameters.Integer(
            'Revison',
            required=False
        )
        use_last_resources = sdk2.parameters.Bool(
            'Use last released resources',
            required=True,
            default=False
        )

    def get_trunk_path(self):
        return self.ramdrive.path / 'trunk'

    def on_execute(self):
        gencfg = environment.GencfgEnvironment(self, self.Parameters.revision, self.get_trunk_path())

        gencfg.prepare()
        self.Context.gencfg_revision = int(gencfg.info(gencfg.src_root)['commit_revision'])
        self.set_info('Task manipulates gencfg revision {}'.format(self.Context.gencfg_revision))

        gencfg.install(self.Parameters.use_last_resources)
        gencfg.run_process(['./utils/common/precalc_caches.py', '--no-nanny', '--no-configs'], 'precalc_caches')

        try:
            gencfg.gen_sh('run_checks')
        finally:
            gencfg.create_resource(CONFIG_BUILD_LOGS, os.path.join(gencfg.src_root, 'build'), 'build')

        try:
            groups_hbf_info = gencfg.run_process_output(
                ['./utils/sandbox/get_groups_to_hbf_mapping.py'], 'get_groups_to_hbf_mapping'
            )
            gencfg.create_text_resource(GencfgGroupsHbfInfo, 'gencfg_groups_hbf_info.json', groups_hbf_info)
        except Exception as e:
            raise TaskFailure('[{}] {}'.format(type(e).__name__, e))
