# -*- coding: utf-8 -*-

import os

from sandbox import sdk2
import not_broken_chart
import build_speed_chart
import tags_release_delay
import test_stages_speed


class GencfgMonitoringCharts(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        days_to_watch_count = sdk2.parameters.Integer('days to watch count')

        skip_not_broken = sdk2.parameters.Bool('Skip not broken', default=False)
        skip_test_speed = sdk2.parameters.Bool('Skip test speed', default=False)
        skip_build_speed = sdk2.parameters.Bool('Skip build speed', default=False)
        skip_build_delay = sdk2.parameters.Bool('Skip build delay', default=False)
        skip_speed_test_stages = sdk2.parameters.Bool('Skip speed test spages', default=False)

    def on_execute(self):
        days_count = self.Parameters.days_to_watch_count
        os.environ['SOLOMON_TOKEN'] = sdk2.Vault.data('GENCFG', 'gencfg_default_oauth')

        if not self.Parameters.skip_not_broken:
            not_broken_chart.update_solomon_chart(days_count)
        if not self.Parameters.skip_test_speed:
            build_speed_chart.update_test_speed_chart(days_count)
        if not self.Parameters.skip_build_speed:
            build_speed_chart.update_build_speed_chart(days_count)
        if not self.Parameters.skip_build_delay:
            tags_release_delay.update_build_delay_chart(days_count)
        if not self.Parameters.skip_speed_test_stages:
            test_stages_speed.update_speed_test_stages_chart(days_count)
