# -*- coding: utf-8 -*-
import logging

import sandbox.sdk2
from sandbox.sdk2.service_resources import SandboxTasksBinary


RATE = 30 * 60
MAX_TRIES_COUNT = 3 * 60 * 60 / RATE


class GencfgToYPSD(sandbox.sdk2.Task):
    def _init_tokens(self):
        import os
        os.environ['YP_TOKEN'] = sandbox.sdk2.Vault.data(self.owner, 'yp-token')
        import yt.wrapper as yt
        yt.config['token'] = sandbox.sdk2.Vault.data(self.owner, 'yt-token')

    def on_save(self):
        self.Requirements.tasks_resource = SandboxTasksBinary.find(attrs={
            'target': 'gencfg/GencfgToYPSD/bin',
        }).first().id

    def on_execute(self):
        import infra.clusterstate.services.yp_sd.main as yp_sd
        self._init_tokens()
        tries_count = 0
        while True:
            try:
                yp_sd.update_all(yp_cluster='xdc', readonly=False)
            except Exception:
                logging.exception('')
                tries_count += 1
            finally:
                if tries_count >= MAX_TRIES_COUNT:
                    raise RuntimeError('too many failures')
                raise sandbox.sdk2.WaitTime(RATE)
