# coding: utf8

create_table = {
    'hostusage': """CREATE TABLE IF NOT EXISTS {table_name} (
            host String,
            ts Int64,
            eventDate Date,
            mem_usage Float32,
            cpu_usage Float32,
            hdd_total Float32,
            hdd_usage Float32,
            ssd_total Float32,
            ssd_usage Float32,
            net_rx Float32,
            net_tx Float32
        ) ENGINE = ReplicatedMergeTree(
            '/clickhouse/tables/{table_name}',
            '{{replica}}',
            eventDate,
            (eventDate, host, ts),
            8192
        )""",
    'instanceusage': """CREATE TABLE IF NOT EXISTS {table_name} (
            host String,
            port Int32,
            ts Int64,
            group String,
            eventDate Date,
            major_tag Int32,
            minor_tag Int32,
            version Int64,
            instance_memusage Float32,
            instance_cpuusage Float32,
            instance_anon_memusage Float32,
            instance_net_rx Float32,
            instance_net_tx Float32
        ) ENGINE = ReplicatedMergeTree(
            '/clickhouse/tables/{table_name}',
            '{{replica}}',
            eventDate,
            (eventDate, host, port, ts),
            8192
        )""",
    'metaprjusage': """CREATE TABLE IF NOT EXISTS {table_name} (
            ts Int64,
            eventDate Date,
            metaprj String,
            cpu_usage Float32,
            cpu_allocated Float32,
            memory_usage Float32,
            memory_allocated Float32
        ) ENGINE = ReplicatedMergeTree(
            '/clickhouse/tables/{table_name}',
            '{{replica}}',
            eventDate,
            (eventDate, ts),
            8192
        )""",
    'openstackusage': """CREATE TABLE IF NOT EXISTS {table_name} (
            host String,
            instanceId String,
            ts Int64,
            eventDate Date,
            projectId String,
            mem_usage Float32,
            cpu_usage Float32
        ) ENGINE = ReplicatedMergeTree(
            '/clickhouse/tables/{table_name}',
            '{{replica}}',
            eventDate,
            (eventDate, host, instanceId, ts),
            8192
        )""",
    'ypusage': """CREATE TABLE IF NOT EXISTS {table_name} (
            host String,
            port String,
            ts Int64,
            group String,
            eventDate Date,
            instance_memusage Float32,
            instance_memallocated Float32,
            instance_cpuusage Float32,
            instance_cpuallocated Float32,
            instance_anon_memusage Float32,
            instance_net_rx Float32,
            instance_net_tx Float32
        ) ENGINE = ReplicatedMergeTree(
            '/clickhouse/tables/{table_name}',
            '{{replica}}',
            eventDate,
            (eventDate, host, port, ts),
            8192
        )"""
}


show_tables = 'SHOW TABLES'


drop_table = 'DROP TABLE IF EXISTS {table_name}'
