import os
import datetime
from sandbox import sdk2

import sandbox.common.types.task as ctt
import sandbox.projects.gencfg.environment as environment
import sandbox.common.types.misc as ctm
import sandbox.projects.common.nanny.nanny as nanny


ONE_MONTH = 31


class GencfgDnsJsonDump(sdk2.Resource):
    """ Gencfg dns in json format """
    releasers = ["GENCFG", "robot-gencfg"]
    releasable = True
    ttl = ONE_MONTH


def add_trailing_spaces(path_to_file):
    with open(path_to_file, 'a') as f:
        f.write(' ' * (datetime.datetime.now().hour % 8))


class MakeGencfgDnsResource(nanny.ReleaseToNannyTask2, sdk2.Task):
    class Requirements(sdk2.Task.Requirements):
        ramdrive = ctm.RamDrive(ctm.RamDriveType.TMPFS, 10 * 1024, None)
        cores = 1
        ram = 16 * 1024
        disk_space = 5 * 1024

        class Caches(sdk2.Requirements.Caches):
            pass

    def on_execute(self):
        gencfg = environment.GencfgEnvironment(self, None, self.ramdrive.path)
        gencfg.prepare()
        path_to_file = os.path.join(os.getcwd(), '_exported_gencfg_dns_.json')
        export_command = ['./utils/mongo/populate_dns.py', '-a', 'export-to-file', '-f', path_to_file]
        gencfg.run_process(export_command, 'export_dns_to_file')

        add_trailing_spaces(path_to_file)

        resource = sdk2.ResourceData(GencfgDnsJsonDump(self, "GencfgDnsJsonDump", os.path.basename(path_to_file), ttl=ONE_MONTH))
        resource.ready()

    def on_success(self, prev_status):
        sdk2.Task.on_success(self, prev_status)
        self.on_release(dict(
            releaser=self.author,
            release_status=ctt.ReleaseStatus.STABLE,
            release_subject="GENCFG dns dump",
            email_notifications=dict(to=[], cc=[]),
            release_comments="GENCFG dns dump",
        ))

    def mark_released_resources(self, status, ttl=ONE_MONTH):
        super(MakeGencfgDnsResource, self).mark_released_resources(status, ttl)
