# -*- coding: utf-8 -*-
import sandbox.sdk2.parameters as parameters

from sandbox.projects.gencfg.BaseGencfgGuiRequest import BaseGencfgGuiRequest


class ManipulateHosts(BaseGencfgGuiRequest):
    """ Manipulate hosts """

    class Requirements(BaseGencfgGuiRequest.Requirements):
        pass

    class Context(BaseGencfgGuiRequest.Context):
        pass

    class Parameters(BaseGencfgGuiRequest.Parameters):
        with parameters.Group('Request params') as request_params:
            with parameters.RadioGroup('Action') as action:
                action.values['replace'] = action.Value(value='Replace', default=True)
                # action.values['ctype'] = action.Value(value='move')

            list_hosts = parameters.List('List of hosts', required=True)
            fields = parameters.Dict('Action fields', required=False)

    def fiil_input_params(self, requests_params):
        pass

    def run_subtask_payload(self, gencfg, params):
        if str(params.action) == 'replace':
            self.replace_hosts_in_group(gencfg, params)
        else:
            self.set_info('Action `{}` not supported.'.format(str(params.action)))

    def list_to_comma_separated(self, lst):
        return ','.join(map(str, lst))

    def replace_hosts_in_group(self, gencfg, params):
        remove_slaves_command = [
            './utils/common/update_igroups.py',
            '-y',
            '-a', 'removeslavehosts',
            '-g', params.fields['group_name'],
            '-s', self.list_to_comma_separated(params.list_hosts)
        ]
        gencfg.run_process(remove_slaves_command, 'removeslavehosts')

        add_new_hosts_command = [
            './optimizers/dynamic/recluster.py',
            '-y',
            '-g', params.fields['group_name'],
            '--instances', str(len(params.list_hosts)),
            '--hosts-flt', "lambda x: x.name not in '{}'.split(',')".format(
                self.list_to_comma_separated(params.list_hosts)
            )
        ]
        gencfg.run_process(add_new_hosts_command, 'add_new_hosts_command')
