# coding: utf8

import os

import sandbox.common.types.misc as ctm
from sandbox import sdk2
from sandbox.sandboxsdk.process import run_process
from sandbox.projects.common.gencfg import utils as config_generator_utils


class MonitorShedulerState(sdk2.Task):
    """Push sheduler's state to solomon (RX-1501)"""

    class Requirements(sdk2.Task.Requirements):
        ramdrive = ctm.RamDrive(ctm.RamDriveType.TMPFS, 10 * 1024, None)
        cores = 1
        ram = 4096
        disk_space = 4096

        class Caches(sdk2.Requirements.Caches):
            pass

    def on_execute(self):
        my_env = os.environ.copy()
        my_env['GENCFG_DEFAULT_OAUTH'] = sdk2.Vault.data('GENCFG', 'gencfg_default_oauth')
        config_generator_utils.clone_gencfg_repo(config_generator_utils.GENCFG_TRUNK_SRC_PATH, self.get_trunk_path())

        run_process(
            [
                './utils/common/push_shedulers_state_to_solomon.py',
                '--project', 'gencfg_monitoring',
                '--cluster', 'production',
                '--service', 'sheduler_state',
                '--wait', '1', '--retries', '5'
            ],
            work_dir=self.get_trunk_path(),
            log_prefix='monitor_sheduler_state',
            environment=my_env)

    def get_trunk_path(self):
        return str(self.ramdrive.path / 'trunk')
