# -*- coding: utf-8 -*-
import sandbox.sdk2.parameters as parameters

from sandbox.projects.gencfg.BaseGencfgGuiRequest import BaseGencfgGuiRequest


class ReplaceSlaveHosts(BaseGencfgGuiRequest):
    """ Replace hosts in static slave group """

    class Requirements(BaseGencfgGuiRequest.Requirements):
        pass

    class Context(BaseGencfgGuiRequest.Context):
        pass

    class Parameters(BaseGencfgGuiRequest.Parameters):
        with parameters.Group('Request params') as request_params:
            group_name = parameters.String('GenCfg group', required=True)
            hosts_to_replace = parameters.List('Hosts to replace', required=True)
            replacement_hosts = parameters.List('New hosts', required=True)

    def fill_input_params(self, requests_params):
        pass

    def run_subtask_payload(self, gencfg, params):
        self.replace_hosts_in_group(gencfg, params)

    def run_full_checks(self, gencfg, params):
        gencfg.gen_sh('run_checks')

    @staticmethod
    def list_to_comma_separated(lst):
        return ','.join(map(str, lst))

    def replace_hosts_in_group(self, gencfg, params):
        remove_slaves_command = [
            './utils/common/update_igroups.py',
            '-y',
            '-a', 'removeslavehosts',
            '-g', params.group_name,
            '-s', self.list_to_comma_separated(params.hosts_to_replace)
        ]
        gencfg.run_process(remove_slaves_command, 'remove_slave_hosts_command')

        add_new_hosts_command = [
            './utils/common/update_igroups.py',
            '-y',
            '-a', 'addslavehosts',
            '-g', params.group_name,
            '-s', self.list_to_comma_separated(params.replacement_hosts)
        ]
        gencfg.run_process(add_new_hosts_command, 'add_new_hosts_command')
