# coding: utf8

import time

import sandbox.common.types.misc as ctm
import sandbox.projects.gencfg.environment as environment

from sandbox import sdk2


class UploadAbcToClickhouse(sdk2.Task):
    """Upload abc projects statistics to <abcusage> table in gencfg clickhouse"""

    class Requirements(sdk2.Task.Requirements):
        ramdrive = ctm.RamDrive(ctm.RamDriveType.TMPFS, 10 * 1024, None)

    class Parameters(sdk2.Task.Parameters):
        duration = sdk2.parameters.Integer(
            'Task duration',
            required=True
        )

    def on_execute(self):
        self.gencfg = environment.GencfgEnvironment(self, None, self.get_trunk_path())
        self.gencfg.prepare()
        self.gencfg.install()

        endt = int(time.time()) + self.Parameters.duration
        step = 0
        while time.time() < endt:
            self.gencfg.run_process(['./utils/common/manipulate_abc_graphs.py', '-a', 'fillstats'], 'abc_stats.{}'.format(step))
            self.gencfg.run_process(['./utils/common/export_volumes_to_clickhouse.py', '-a', 'addstats'], 'volumes_stats.{}'.format(step))
            step += 1
            time.sleep(60)

    def get_trunk_path(self):
        return self.ramdrive.path / 'trunk'
