from sandbox import sdk2


class CAJUPER_SAMOGON(sdk2.Resource):
    """
        resource with helloworld samogon service.
    """
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = ['cerg1168']


class GENCFG_HOSTINFO_BINARY(sdk2.Resource):
    """
        resource with service to respond on group cards/group searcherlookups/...
    """
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = ['cerg1168', 'okats', 'mcden', 'kimkim']


class GENCFG_PYTHON_VENV(sdk2.Resource):
    """
    File with gencfg binutils, as tar.gz
    """
    any_arch = True
    auto_backup = True
    executable = False
    releasable = True


class GENCFG_BALANCER_PYTHON_VENV(sdk2.Resource):
    """
    File with gencfg binutils, as tar.gz
    """
    any_arch = True
    auto_backup = True
    executable = False
    releasable = True


class CONFIG_GENERATOR_CONFIGS_TGZ(sdk2.Resource):
    """
    Tarball with configs for all instances, archived with tar -z
    """
    releasable = True
    auto_backup = True
    releasers = [
        'sandbox',
        'sereglond',
        'robot-gencfg',
        'kulikov',
        'vmordovin',
        'okats',
        'mcden'
    ]


class CONFIG_GENERATOR_CONFIGS_WEB(sdk2.Resource):
    """
    Tarball with configs for web instances, archived with tar -z
    """
    releasable = True
    auto_backup = True
    releasers = [
        'sandbox',
        'robot-gencfg',
        'kulikov',
        'vmordovin',
        'okats',
        'mcden'
    ]


class CONFIG_GENERATOR_CONFIGS_VIDEO(sdk2.Resource):
    """
    Tarball with configs for web instances, archived with tar -z
    """
    releasable = True
    auto_backup = True
    releasers = [
        'sandbox',
        'robot-gencfg',
        'kulikov',
        'vmordovin',
        'okats',
        'mcden'
    ]
