# coding: utf8
import functools


def procedure_call_logging(func):
    @functools.wraps(func)
    def procedure(self, *args, **kwargs):
        self.gencfgenv.writeln('Run {} with ({}), ({})'.format(func.__name__, args, kwargs))
        return func(self, *args, **kwargs)
    return procedure


class GencfgWorkflow(object):
    def __init__(self, gencfgenv):
        self.gencfgenv = gencfgenv

    @procedure_call_logging
    def sync_with_racktables_scenario(self, sync_rt_to_gencfg=False, sync_gencfg_to_rt=False, upload_diff_to_rt=False, upload_limit=20):
        if sync_gencfg_to_rt:
            self.gencfgenv.manipulate_hbf_ranges(
                action='sync_project_ids',
                upload_to_rt=upload_diff_to_rt,
                upload_limit=upload_limit
            )
        if sync_rt_to_gencfg:
            self.gencfgenv.manipulate_hbf_ranges(action='sync_macros_info', apply_changes=True)

    @procedure_call_logging
    def sync_with_dispenser_scenario(self, sync_dispenser_to_gencfg=False, sync_gencfg_to_dispenser=False, upload_to_dispenser=False):
        if sync_dispenser_to_gencfg:
            self.gencfgenv.manipulate_dispenser(action='sync_from_dispenser', apply_changes=True, verbose=True)

        if sync_gencfg_to_dispenser:
            self.gencfgenv.manipulate_dispenser(action='sync_actual_quotas', upload_to_dispenser=upload_to_dispenser, verbose=True)

        if sync_dispenser_to_gencfg and sync_gencfg_to_dispenser:
            self.gencfgenv.manipulate_dispenser(action='sync_from_dispenser', apply_changes=True, verbose=True)

    @procedure_call_logging
    def change_group_volumes_scenario(self, group_name_list, volumes):
        self.gencfgenv.manipulate_volumes(action='put', group_name_list=group_name_list, volumes=volumes)

    @procedure_call_logging
    def change_group_card_scenario(self, group_name_list, fields):
        """
        Change group card fields
        :param group_name_list: ["GROUP_NAME1", "GROUP_NAME2"]
        :param fields: {"owners": ["user", "departament"], "properties.hbf_parent_macros": "_YANDEXNETS_"}
        :return: None
        """
        for field_key, field_value in fields.items():
            if field_key in ('reqs.volumes',):
                self.gencfgenv.manipulate_volumes(action='put', group_name_list=group_name_list, volumes=field_value)
            else:
                self.gencfgenv.update_card(group_name_list=group_name_list, key=field_key, value=field_value)

    @procedure_call_logging
    def remove_group_scenario(self, group_name_list):
        """
        Actions with group
        :param group_name_list: ["GROUP_NAME1", "GROUP_NAME2"]
        :return: None
        """
        for group_name in group_name_list:
            self.gencfgenv.update_igroups(action='remove', group_name=group_name)
