# coding: utf8
import sandbox.common.types.task as ctt
import sandbox.sdk2.parameters as parameters
import sandbox.projects.gencfg.workflow.workflow as wf

from sandbox.projects.gencfg.workflow_tasks.GencfgSdkTaskBase import GencfgSdkTaskBase


class GencfgRemoveGroup(GencfgSdkTaskBase):
    """ Remove GenCfg Group """

    class Requirements(GencfgSdkTaskBase.Requirements):
        semaphores = ctt.Semaphores(
            acquires=[
                ctt.Semaphores.Acquire(name='GENCFG_SDK_TASKS_SEMAPHORE', weight=1),
                ctt.Semaphores.Acquire(name='GENCFG_SDK_ASYNC_TASKS_SEMAPHORE', weight=1),
            ],
            release=(ctt.Status.Group.BREAK, ctt.Status.Group.FINISH)
        )

    class Context(GencfgSdkTaskBase.Context):
        pass

    class Parameters(GencfgSdkTaskBase.Parameters):
        with parameters.Group('Request') as request:
            group_name_list = parameters.List('Group list')

    def fill_task_parameters(self, params):
        self.Parameters.group_name_list = params['group_list']

    def run_task_logic(self, gencfgenv, params):
        workflow = wf.GencfgWorkflow(gencfgenv)
        workflow.remove_group_scenario(
            group_name_list=params.group_name_list,
        )
