# coding: utf8
import sandbox.common.types.misc as ctm
import sandbox.common.types.client as ctc
import sandbox.projects.gencfg.workflow.gencfg as gencfg

from sandbox import sdk2


class GencfgRunGenSh(sdk2.Task):
    """ Check updates and run tasks """

    class Requirements(sdk2.Task.Requirements):
        ramdrive = ctm.RamDrive(ctm.RamDriveType.TMPFS, 10 * 1024, None)
        client_tags = ctc.Tag.CUSTOM_GENCFG_BUILD

    class Parameters(sdk2.Task.Parameters):
        revision = sdk2.parameters.Integer('Revison', required=False)
        gencfg_option = sdk2.parameters.String('./gen.sh option', default='run_checks')
        gencfg_native_mode = sdk2.parameters.Bool('Native mode', default=True)
        last_resources = sdk2.parameters.Bool('Use last released resources', default=True)
        use_ramdrive = sdk2.parameters.Bool('Use ramdrive', default=True)

    def on_execute(self):
        revision = self.Parameters.revision or None
        option = self.Parameters.gencfg_option or ''
        gencfg_native_mode = self.Parameters.gencfg_native_mode
        last_resources = self.Parameters.last_resources
        use_ramdrive = self.Parameters.use_ramdrive
        basedir = str(self.ramdrive.path / 'arc') if use_ramdrive else str(self.log_path())
        gencfgenv = gencfg.Gencfg(basedir, str(self.log_path()), self.Parameters.revision)

        gencfgenv.checkout(by_subprocess=gencfg_native_mode)
        gencfgenv.install(last_resources, by_subprocess=gencfg_native_mode)

        try:
            gencfgenv.gen_sh(option)
        finally:
            gencfgenv.create_sandbox_resource(
                sdk2.Resource['CONFIG_BUILD_LOGS'],
                gencfgenv.gencfg_build_path,
                self,
                'build',
                'Created form r{} by {}'.format(revision, self.id)
            )

    def on_finish(self, prev_status, status):
        pass

    def on_break(self, prev_status, status):
        pass
