# coding: utf8
import sandbox.common.types.task as ctt
import sandbox.sdk2.parameters as parameters
import sandbox.projects.gencfg.workflow.workflow as wf

from sandbox.projects.gencfg.workflow_tasks.GencfgSdkTaskBase import GencfgSdkTaskBase


class GencfgSyncWithDispenser(GencfgSdkTaskBase):
    """ Sync GenCfg DB with Dispenser """

    class Requirements(GencfgSdkTaskBase.Requirements):
        semaphores = ctt.Semaphores(
            acquires=[
                ctt.Semaphores.Acquire(name='GENCFG_SDK_TASKS_SEMAPHORE', weight=1),
                ctt.Semaphores.Acquire(name='GENCFG_SDK_ASYNC_TASKS_SEMAPHORE', weight=1),
            ],
            release=(ctt.Status.Group.BREAK, ctt.Status.Group.FINISH)
        )

    class Context(GencfgSdkTaskBase.Context):
        pass

    class Parameters(GencfgSdkTaskBase.Parameters):
        with parameters.Group('Request') as request:
            sync_dispenser_to_gencfg = parameters.Bool('Sync from Dispenser to GenCfg', default=False)
            sync_gencfg_to_dispenser = parameters.Bool('Sync from GenCfg to Dispenser', default=False)

    def fill_task_parameters(self, params):
        self.Parameters.sync_dispenser_to_gencfg = params.get('sync_dispenser_to_gencfg', False)
        self.Parameters.sync_gencfg_to_dispenser = params.get('sync_gencfg_to_dispenser', False)

    def run_task_logic(self, gencfgenv, params):
        workflow = wf.GencfgWorkflow(gencfgenv)
        workflow.sync_with_dispenser_scenario(
            sync_dispenser_to_gencfg=params.sync_dispenser_to_gencfg,
            sync_gencfg_to_dispenser=params.sync_gencfg_to_dispenser,
            upload_to_dispenser=not params.dry_run
        )
