# coding: utf8
import sandbox.common.types.task as ctt
import sandbox.sdk2.parameters as parameters
import sandbox.projects.gencfg.workflow.workflow as wf

from sandbox.projects.gencfg.workflow_tasks.GencfgSdkTaskBase import GencfgSdkTaskBase


class GencfgSyncWithRacktables(GencfgSdkTaskBase):
    """ Sync GenCfg DB with RackTables """

    class Requirements(GencfgSdkTaskBase.Requirements):
        semaphores = ctt.Semaphores(
            acquires=[
                ctt.Semaphores.Acquire(name='GENCFG_SDK_TASKS_SEMAPHORE', weight=1),
                ctt.Semaphores.Acquire(name='GENCFG_SDK_ASYNC_TASKS_SEMAPHORE', weight=1),
            ],
            release=(ctt.Status.Group.BREAK, ctt.Status.Group.FINISH)
        )

    class Context(GencfgSdkTaskBase.Context):
        pass

    class Parameters(GencfgSdkTaskBase.Parameters):
        with parameters.Group('Request') as request:
            sync_rt_to_gencfg = parameters.Bool('Sync from RackTables to GenCfg', default=False)
            sync_gencfg_to_rt = parameters.Bool('Sync from GenCfg to RackTables', default=False)
            upload_diff_to_rt = parameters.Bool('Upload diff to RackTables', default=False)
            upload_limit = parameters.Integer('Limit for upload move changes to RackTables', default=20)

    def fill_task_parameters(self, params):
        self.Parameters.sync_rt_to_gencfg = params.get('sync_rt_to_gencfg', False)
        self.Parameters.sync_gencfg_to_rt = params.get('sync_gencfg_to_rt', False)
        self.Parameters.upload_diff_to_rt = params.get('upload_diff_to_rt', False)
        self.Parameters.upload_limit = params.get('upload_limit', 20)

    def run_task_logic(self, gencfgenv, params):
        workflow = wf.GencfgWorkflow(gencfgenv)
        workflow.sync_with_racktables_scenario(
            sync_rt_to_gencfg=params.sync_rt_to_gencfg,
            sync_gencfg_to_rt=params.sync_gencfg_to_rt,
            upload_diff_to_rt=params.upload_diff_to_rt and not params.dry_run,
            upload_limit=params.upload_limit
        )
