# -*- coding: utf-8 -*-
import json
import sandbox.sdk2.parameters as parameters

from sandbox.projects.gencfg.workflow_tasks.GencfgSdkTaskBase import GencfgSdkTaskBase


class GencfgUtilsRunner(GencfgSdkTaskBase):
    """ Remove group if it unused """

    class Requirements(GencfgSdkTaskBase.Requirements):
        pass

    class Context(GencfgSdkTaskBase.Context):
        pass

    class Parameters(GencfgSdkTaskBase.Parameters):
        with parameters.Group('Request') as request:
            recipe = parameters.JSON('Recipe', default='[]', required=True)

    def fill_task_parameters(self, params):
        self.Parameters.recipe = json.dumps(params['recipe'])

    def run_task_logic(self, gencfgenv, params):
        for util in params.recipe:
            until_name = util['name']
            util_kwargs = util['kwargs']
            util_method = getattr(gencfgenv, until_name)
            util_method(**util_kwargs)
