# -*- coding: utf-8 -*-
import json
import sandbox.sdk2.parameters as parameters
import sandbox.projects.gencfg.workflow.workflow as wf

from sandbox.projects.gencfg.workflow_tasks.GencfgSdkTaskBase import GencfgSdkTaskBase


class GencfgWorkflowRunner(GencfgSdkTaskBase):
    """ Start workflow scenario and commit results """

    class Requirements(GencfgSdkTaskBase.Requirements):
        pass

    class Context(GencfgSdkTaskBase.Context):
        pass

    class Parameters(GencfgSdkTaskBase.Parameters):
        with parameters.Group('Request') as request:
            scenarios = parameters.JSON('Scenarios', default=[], required=True)
            skip_failed_steps = parameters.Bool('Skip failed steps', default=False)
            skip_failed_steps_but_failure = parameters.Bool('Skip failed steps but failure', default=False)

    def fill_task_parameters(self, params):
        self.Parameters.scenarios = json.dumps(params['scenarios'])
        self.Parameters.skip_failed_steps = params.get('skip_failed_steps', False)

    def run_task_logic(self, gencfgenv, params):
        failed_steps = []

        workflow = wf.GencfgWorkflow(gencfgenv)
        for i, util in enumerate(params.scenarios):
            scenario_name = util['scenario']
            scenario_kwargs = util['kwargs']
            scenario_method = getattr(workflow, scenario_name)

            try:
                scenario_method(**scenario_kwargs)
            except Exception as e:
                if not params.skip_failed_steps and not params.skip_failed_steps_but_failure:
                    raise
                gencfgenv.writeln('[SKIP ERROR] ({}) {}: {}'.format(i, type(e).__name__, e))
                self.set_info('[SKIP ERROR] ({}) {}: {}'.format(i, scenario_name, e))
                failed_steps.append(util)

        if failed_steps and params.skip_failed_steps_but_failure:
            raise ValueError('Can not finish workflow because errors in some steps')
