# -*- coding: utf-8 -*-

from sandbox import sdk2
from sandbox.sandboxsdk import process
import os
from sandbox.sandboxsdk.environments import PipEnvironment


class GeoAdvMonthlyAudienceStat(sdk2.Task):

    class Parameters(sdk2.Task.Parameters):
        destinationTable = sdk2.parameters.String("Destination table")

    class Requirements(sdk2.Requirements):
        environments = [
            PipEnvironment("yandex-yt"),
            PipEnvironment("yandex-yt-yson-bindings-skynet"),
            PipEnvironment("yql")
        ]

    def on_execute(self):
        env = os.environ.copy()
        env["YT_PROXY"] = "hahn.yt.yandex.net"
        env["YT_TOKEN"] = sdk2.Vault.data(self.owner, "ANTIPICH_YT_TOKEN")
        env["YQL_TOKEN"] = sdk2.Vault.data(self.owner, "ANTIPICH_YQL_TOKEN")

        process.run_process(
            cmd=[
                '/skynet/python/bin/python',
                os.path.join(os.path.dirname(__file__), "upload_stats.py")
            ],
            log_prefix="upload_stats",
            wait=True,
            check=True,
            environment=env
        )
