import re

from sandbox import sdk2

from .base import GeoadvRankingBuildTarget, AbstractGeoadvRankingBuildTask, BuildTargetsParameter


class GeoadvRankingBuildTask(AbstractGeoadvRankingBuildTask):
    class Parameters(AbstractGeoadvRankingBuildTask.Parameters):
        build_targets = BuildTargetsParameter('List of targets to build')

    def get_build_targets(self):
        return BuildTargetsParameter.cast(self.Parameters.build_targets, return_orig=False)


class BuildGeoadvBinarySandboxTask(AbstractGeoadvRankingBuildTask):
    def get_build_targets(self):
        return [
            GeoadvRankingBuildTarget(
                'sandbox/projects/geoadv_ranking/bin/geoadv-ranking-tasks-runner',
                True,
                sdk2.service_resources.SandboxTasksBinary,
            ),
        ]

    def on_release(self, additional_parameters):
        super(BuildGeoadvBinarySandboxTask, self).on_release(additional_parameters)

        binary_task_resource = next(iter(sdk2.Resource.find(
            task=self,
            type=sdk2.service_resources.SandboxTasksBinary,
        ).limit(1)), None)

        match = re.search("Task: *([a-zA-Z_]+)", additional_parameters['release_comments'])
        if match:
            binary_task_resource.task_type = match.group(1)
