from sandbox import sdk2
from sandbox.common.errors import TaskFailure
from sandbox.common.types.task import Status


def wait_subtasks(task_ids):
    raise sdk2.WaitTask(task_ids, Status.Group.FINISH | Status.Group.BREAK, wait_all=True)


def validate_subtask_statuses(task_ids):
    failed_tasks = filter(lambda task_id: sdk2.Task[task_id].status not in Status.Group.SUCCEED, task_ids)

    if failed_tasks:
        raise TaskFailure('{} child tasks failed'.format(len(failed_tasks)))
