from sandbox.sdk2 import Resource


class GeoadvReleaseResource(Resource):
    releasable = True
    auto_backup = True
    releasers = ['GEOADV_RANKING']


class GeoadvArcadiaProject(GeoadvReleaseResource):
    pass


class BaseGeoCompetitorsExecutable(GeoadvReleaseResource):
    pass


class SimilarAdvertsIndexer(BaseGeoCompetitorsExecutable):
    """
       Executable for building similar adverts index
    """


class MapsCompetitorsFormula(GeoadvReleaseResource):
    """
       Ranking formula for competitor advert.
    """
    pass


class PrepareDataFromShardExecutable(BaseGeoCompetitorsExecutable):
    """
       Executable for exporting data from geosearch base shards
    """


class GeoproductAddrsConfigs(GeoadvReleaseResource):
    pass


class GeoproductAddrsItsUpdater(GeoadvReleaseResource):
    pass


class ExtmapsPromoPortoLayer(GeoadvReleaseResource):
    """
       Porto layer for extmaps_promo_production service
    """
    pass


class ExtmapsPromoBackendExecutable(GeoadvReleaseResource):
    """
       Backend executable for extmaps_promo_production service
    """
    pass


class ExtmapsPromoPlanexExecutable(GeoadvReleaseResource):
    """
       Planex client for extmaps_promo_production service
    """
    pass


class ExtmapsPromoManageExecutable(GeoadvReleaseResource):
    """
       Manage.py script for django operations on extmaps_promo_production service
    """
    pass


class AmlApiBundle(GeoadvReleaseResource):
    """
        Aml api bundle
    """
